import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\AllJobs\Pages\EditAllJob::__invoke
* @see app/Filament/Resources/AllJobs/Pages/EditAllJob.php:7
* @route '/recruiter/all-jobs/{record}/edit'
*/
const EditAllJob = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: EditAllJob.url(args, options),
    method: 'get',
})

EditAllJob.definition = {
    methods: ["get","head"],
    url: '/recruiter/all-jobs/{record}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\AllJobs\Pages\EditAllJob::__invoke
* @see app/Filament/Resources/AllJobs/Pages/EditAllJob.php:7
* @route '/recruiter/all-jobs/{record}/edit'
*/
EditAllJob.url = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { record: args }
    }

    if (Array.isArray(args)) {
        args = {
            record: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        record: args.record,
    }

    return EditAllJob.definition.url
            .replace('{record}', parsedArgs.record.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Filament\Resources\AllJobs\Pages\EditAllJob::__invoke
* @see app/Filament/Resources/AllJobs/Pages/EditAllJob.php:7
* @route '/recruiter/all-jobs/{record}/edit'
*/
EditAllJob.get = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: EditAllJob.url(args, options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\AllJobs\Pages\EditAllJob::__invoke
* @see app/Filament/Resources/AllJobs/Pages/EditAllJob.php:7
* @route '/recruiter/all-jobs/{record}/edit'
*/
EditAllJob.head = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: EditAllJob.url(args, options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\AllJobs\Pages\EditAllJob::__invoke
* @see app/Filament/Resources/AllJobs/Pages/EditAllJob.php:7
* @route '/recruiter/all-jobs/{record}/edit'
*/
const EditAllJobForm = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: EditAllJob.url(args, options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\AllJobs\Pages\EditAllJob::__invoke
* @see app/Filament/Resources/AllJobs/Pages/EditAllJob.php:7
* @route '/recruiter/all-jobs/{record}/edit'
*/
EditAllJobForm.get = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: EditAllJob.url(args, options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\AllJobs\Pages\EditAllJob::__invoke
* @see app/Filament/Resources/AllJobs/Pages/EditAllJob.php:7
* @route '/recruiter/all-jobs/{record}/edit'
*/
EditAllJobForm.head = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: EditAllJob.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

EditAllJob.form = EditAllJobForm

export default EditAllJob