import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\AllJobs\Pages\ListAllJobs::__invoke
* @see app/Filament/Resources/AllJobs/Pages/ListAllJobs.php:7
* @route '/recruiter/all-jobs'
*/
const ListAllJobs = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ListAllJobs.url(options),
    method: 'get',
})

ListAllJobs.definition = {
    methods: ["get","head"],
    url: '/recruiter/all-jobs',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\AllJobs\Pages\ListAllJobs::__invoke
* @see app/Filament/Resources/AllJobs/Pages/ListAllJobs.php:7
* @route '/recruiter/all-jobs'
*/
ListAllJobs.url = (options?: RouteQueryOptions) => {
    return ListAllJobs.definition.url + queryParams(options)
}

/**
* @see \App\Filament\Resources\AllJobs\Pages\ListAllJobs::__invoke
* @see app/Filament/Resources/AllJobs/Pages/ListAllJobs.php:7
* @route '/recruiter/all-jobs'
*/
ListAllJobs.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ListAllJobs.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\AllJobs\Pages\ListAllJobs::__invoke
* @see app/Filament/Resources/AllJobs/Pages/ListAllJobs.php:7
* @route '/recruiter/all-jobs'
*/
ListAllJobs.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: ListAllJobs.url(options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\AllJobs\Pages\ListAllJobs::__invoke
* @see app/Filament/Resources/AllJobs/Pages/ListAllJobs.php:7
* @route '/recruiter/all-jobs'
*/
const ListAllJobsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ListAllJobs.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\AllJobs\Pages\ListAllJobs::__invoke
* @see app/Filament/Resources/AllJobs/Pages/ListAllJobs.php:7
* @route '/recruiter/all-jobs'
*/
ListAllJobsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ListAllJobs.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\AllJobs\Pages\ListAllJobs::__invoke
* @see app/Filament/Resources/AllJobs/Pages/ListAllJobs.php:7
* @route '/recruiter/all-jobs'
*/
ListAllJobsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ListAllJobs.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

ListAllJobs.form = ListAllJobsForm

export default ListAllJobs