import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\Companies\Pages\ListCompanies::__invoke
* @see app/Filament/Resources/Companies/Pages/ListCompanies.php:7
* @route '/recruiter/companies'
*/
const ListCompanies = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ListCompanies.url(options),
    method: 'get',
})

ListCompanies.definition = {
    methods: ["get","head"],
    url: '/recruiter/companies',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\Companies\Pages\ListCompanies::__invoke
* @see app/Filament/Resources/Companies/Pages/ListCompanies.php:7
* @route '/recruiter/companies'
*/
ListCompanies.url = (options?: RouteQueryOptions) => {
    return ListCompanies.definition.url + queryParams(options)
}

/**
* @see \App\Filament\Resources\Companies\Pages\ListCompanies::__invoke
* @see app/Filament/Resources/Companies/Pages/ListCompanies.php:7
* @route '/recruiter/companies'
*/
ListCompanies.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ListCompanies.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Companies\Pages\ListCompanies::__invoke
* @see app/Filament/Resources/Companies/Pages/ListCompanies.php:7
* @route '/recruiter/companies'
*/
ListCompanies.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: ListCompanies.url(options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\Companies\Pages\ListCompanies::__invoke
* @see app/Filament/Resources/Companies/Pages/ListCompanies.php:7
* @route '/recruiter/companies'
*/
const ListCompaniesForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ListCompanies.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Companies\Pages\ListCompanies::__invoke
* @see app/Filament/Resources/Companies/Pages/ListCompanies.php:7
* @route '/recruiter/companies'
*/
ListCompaniesForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ListCompanies.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Companies\Pages\ListCompanies::__invoke
* @see app/Filament/Resources/Companies/Pages/ListCompanies.php:7
* @route '/recruiter/companies'
*/
ListCompaniesForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ListCompanies.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

ListCompanies.form = ListCompaniesForm

export default ListCompanies