import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\Experiences\Pages\ManageExperiences::__invoke
* @see app/Filament/Resources/Experiences/Pages/ManageExperiences.php:7
* @route '/recruiter/experiences'
*/
const ManageExperiences = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ManageExperiences.url(options),
    method: 'get',
})

ManageExperiences.definition = {
    methods: ["get","head"],
    url: '/recruiter/experiences',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\Experiences\Pages\ManageExperiences::__invoke
* @see app/Filament/Resources/Experiences/Pages/ManageExperiences.php:7
* @route '/recruiter/experiences'
*/
ManageExperiences.url = (options?: RouteQueryOptions) => {
    return ManageExperiences.definition.url + queryParams(options)
}

/**
* @see \App\Filament\Resources\Experiences\Pages\ManageExperiences::__invoke
* @see app/Filament/Resources/Experiences/Pages/ManageExperiences.php:7
* @route '/recruiter/experiences'
*/
ManageExperiences.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ManageExperiences.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Experiences\Pages\ManageExperiences::__invoke
* @see app/Filament/Resources/Experiences/Pages/ManageExperiences.php:7
* @route '/recruiter/experiences'
*/
ManageExperiences.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: ManageExperiences.url(options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\Experiences\Pages\ManageExperiences::__invoke
* @see app/Filament/Resources/Experiences/Pages/ManageExperiences.php:7
* @route '/recruiter/experiences'
*/
const ManageExperiencesForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageExperiences.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Experiences\Pages\ManageExperiences::__invoke
* @see app/Filament/Resources/Experiences/Pages/ManageExperiences.php:7
* @route '/recruiter/experiences'
*/
ManageExperiencesForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageExperiences.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Experiences\Pages\ManageExperiences::__invoke
* @see app/Filament/Resources/Experiences/Pages/ManageExperiences.php:7
* @route '/recruiter/experiences'
*/
ManageExperiencesForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageExperiences.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

ManageExperiences.form = ManageExperiencesForm

export default ManageExperiences