import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\JobApplications\Pages\ListJobApplications::__invoke
* @see app/Filament/Resources/JobApplications/Pages/ListJobApplications.php:7
* @route '/recruiter/job-applications'
*/
const ListJobApplications = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ListJobApplications.url(options),
    method: 'get',
})

ListJobApplications.definition = {
    methods: ["get","head"],
    url: '/recruiter/job-applications',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\JobApplications\Pages\ListJobApplications::__invoke
* @see app/Filament/Resources/JobApplications/Pages/ListJobApplications.php:7
* @route '/recruiter/job-applications'
*/
ListJobApplications.url = (options?: RouteQueryOptions) => {
    return ListJobApplications.definition.url + queryParams(options)
}

/**
* @see \App\Filament\Resources\JobApplications\Pages\ListJobApplications::__invoke
* @see app/Filament/Resources/JobApplications/Pages/ListJobApplications.php:7
* @route '/recruiter/job-applications'
*/
ListJobApplications.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ListJobApplications.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\JobApplications\Pages\ListJobApplications::__invoke
* @see app/Filament/Resources/JobApplications/Pages/ListJobApplications.php:7
* @route '/recruiter/job-applications'
*/
ListJobApplications.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: ListJobApplications.url(options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\JobApplications\Pages\ListJobApplications::__invoke
* @see app/Filament/Resources/JobApplications/Pages/ListJobApplications.php:7
* @route '/recruiter/job-applications'
*/
const ListJobApplicationsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ListJobApplications.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\JobApplications\Pages\ListJobApplications::__invoke
* @see app/Filament/Resources/JobApplications/Pages/ListJobApplications.php:7
* @route '/recruiter/job-applications'
*/
ListJobApplicationsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ListJobApplications.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\JobApplications\Pages\ListJobApplications::__invoke
* @see app/Filament/Resources/JobApplications/Pages/ListJobApplications.php:7
* @route '/recruiter/job-applications'
*/
ListJobApplicationsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ListJobApplications.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

ListJobApplications.form = ListJobApplicationsForm

export default ListJobApplications