import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\LicensedIns\Pages\ManageLicensedIns::__invoke
* @see app/Filament/Resources/LicensedIns/Pages/ManageLicensedIns.php:7
* @route '/recruiter/licensed-ins'
*/
const ManageLicensedIns = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ManageLicensedIns.url(options),
    method: 'get',
})

ManageLicensedIns.definition = {
    methods: ["get","head"],
    url: '/recruiter/licensed-ins',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\LicensedIns\Pages\ManageLicensedIns::__invoke
* @see app/Filament/Resources/LicensedIns/Pages/ManageLicensedIns.php:7
* @route '/recruiter/licensed-ins'
*/
ManageLicensedIns.url = (options?: RouteQueryOptions) => {
    return ManageLicensedIns.definition.url + queryParams(options)
}

/**
* @see \App\Filament\Resources\LicensedIns\Pages\ManageLicensedIns::__invoke
* @see app/Filament/Resources/LicensedIns/Pages/ManageLicensedIns.php:7
* @route '/recruiter/licensed-ins'
*/
ManageLicensedIns.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ManageLicensedIns.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\LicensedIns\Pages\ManageLicensedIns::__invoke
* @see app/Filament/Resources/LicensedIns/Pages/ManageLicensedIns.php:7
* @route '/recruiter/licensed-ins'
*/
ManageLicensedIns.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: ManageLicensedIns.url(options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\LicensedIns\Pages\ManageLicensedIns::__invoke
* @see app/Filament/Resources/LicensedIns/Pages/ManageLicensedIns.php:7
* @route '/recruiter/licensed-ins'
*/
const ManageLicensedInsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageLicensedIns.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\LicensedIns\Pages\ManageLicensedIns::__invoke
* @see app/Filament/Resources/LicensedIns/Pages/ManageLicensedIns.php:7
* @route '/recruiter/licensed-ins'
*/
ManageLicensedInsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageLicensedIns.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\LicensedIns\Pages\ManageLicensedIns::__invoke
* @see app/Filament/Resources/LicensedIns/Pages/ManageLicensedIns.php:7
* @route '/recruiter/licensed-ins'
*/
ManageLicensedInsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageLicensedIns.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

ManageLicensedIns.form = ManageLicensedInsForm

export default ManageLicensedIns