import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\LicensedTypes\Pages\EditLicensedType::__invoke
* @see app/Filament/Resources/LicensedTypes/Pages/EditLicensedType.php:7
* @route '/recruiter/licensed-types/{record}/edit'
*/
const EditLicensedType = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: EditLicensedType.url(args, options),
    method: 'get',
})

EditLicensedType.definition = {
    methods: ["get","head"],
    url: '/recruiter/licensed-types/{record}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\LicensedTypes\Pages\EditLicensedType::__invoke
* @see app/Filament/Resources/LicensedTypes/Pages/EditLicensedType.php:7
* @route '/recruiter/licensed-types/{record}/edit'
*/
EditLicensedType.url = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { record: args }
    }

    if (Array.isArray(args)) {
        args = {
            record: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        record: args.record,
    }

    return EditLicensedType.definition.url
            .replace('{record}', parsedArgs.record.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Filament\Resources\LicensedTypes\Pages\EditLicensedType::__invoke
* @see app/Filament/Resources/LicensedTypes/Pages/EditLicensedType.php:7
* @route '/recruiter/licensed-types/{record}/edit'
*/
EditLicensedType.get = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: EditLicensedType.url(args, options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\LicensedTypes\Pages\EditLicensedType::__invoke
* @see app/Filament/Resources/LicensedTypes/Pages/EditLicensedType.php:7
* @route '/recruiter/licensed-types/{record}/edit'
*/
EditLicensedType.head = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: EditLicensedType.url(args, options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\LicensedTypes\Pages\EditLicensedType::__invoke
* @see app/Filament/Resources/LicensedTypes/Pages/EditLicensedType.php:7
* @route '/recruiter/licensed-types/{record}/edit'
*/
const EditLicensedTypeForm = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: EditLicensedType.url(args, options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\LicensedTypes\Pages\EditLicensedType::__invoke
* @see app/Filament/Resources/LicensedTypes/Pages/EditLicensedType.php:7
* @route '/recruiter/licensed-types/{record}/edit'
*/
EditLicensedTypeForm.get = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: EditLicensedType.url(args, options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\LicensedTypes\Pages\EditLicensedType::__invoke
* @see app/Filament/Resources/LicensedTypes/Pages/EditLicensedType.php:7
* @route '/recruiter/licensed-types/{record}/edit'
*/
EditLicensedTypeForm.head = (args: { record: string | number } | [record: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: EditLicensedType.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

EditLicensedType.form = EditLicensedTypeForm

export default EditLicensedType