import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\LicensedTypes\Pages\ListLicensedTypes::__invoke
* @see app/Filament/Resources/LicensedTypes/Pages/ListLicensedTypes.php:7
* @route '/recruiter/licensed-types'
*/
const ListLicensedTypes = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ListLicensedTypes.url(options),
    method: 'get',
})

ListLicensedTypes.definition = {
    methods: ["get","head"],
    url: '/recruiter/licensed-types',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\LicensedTypes\Pages\ListLicensedTypes::__invoke
* @see app/Filament/Resources/LicensedTypes/Pages/ListLicensedTypes.php:7
* @route '/recruiter/licensed-types'
*/
ListLicensedTypes.url = (options?: RouteQueryOptions) => {
    return ListLicensedTypes.definition.url + queryParams(options)
}

/**
* @see \App\Filament\Resources\LicensedTypes\Pages\ListLicensedTypes::__invoke
* @see app/Filament/Resources/LicensedTypes/Pages/ListLicensedTypes.php:7
* @route '/recruiter/licensed-types'
*/
ListLicensedTypes.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ListLicensedTypes.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\LicensedTypes\Pages\ListLicensedTypes::__invoke
* @see app/Filament/Resources/LicensedTypes/Pages/ListLicensedTypes.php:7
* @route '/recruiter/licensed-types'
*/
ListLicensedTypes.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: ListLicensedTypes.url(options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\LicensedTypes\Pages\ListLicensedTypes::__invoke
* @see app/Filament/Resources/LicensedTypes/Pages/ListLicensedTypes.php:7
* @route '/recruiter/licensed-types'
*/
const ListLicensedTypesForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ListLicensedTypes.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\LicensedTypes\Pages\ListLicensedTypes::__invoke
* @see app/Filament/Resources/LicensedTypes/Pages/ListLicensedTypes.php:7
* @route '/recruiter/licensed-types'
*/
ListLicensedTypesForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ListLicensedTypes.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\LicensedTypes\Pages\ListLicensedTypes::__invoke
* @see app/Filament/Resources/LicensedTypes/Pages/ListLicensedTypes.php:7
* @route '/recruiter/licensed-types'
*/
ListLicensedTypesForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ListLicensedTypes.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

ListLicensedTypes.form = ListLicensedTypesForm

export default ListLicensedTypes