import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\RemoteStatuses\Pages\ManageRemoteStatuses::__invoke
* @see app/Filament/Resources/RemoteStatuses/Pages/ManageRemoteStatuses.php:7
* @route '/recruiter/remote-statuses'
*/
const ManageRemoteStatuses = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ManageRemoteStatuses.url(options),
    method: 'get',
})

ManageRemoteStatuses.definition = {
    methods: ["get","head"],
    url: '/recruiter/remote-statuses',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\RemoteStatuses\Pages\ManageRemoteStatuses::__invoke
* @see app/Filament/Resources/RemoteStatuses/Pages/ManageRemoteStatuses.php:7
* @route '/recruiter/remote-statuses'
*/
ManageRemoteStatuses.url = (options?: RouteQueryOptions) => {
    return ManageRemoteStatuses.definition.url + queryParams(options)
}

/**
* @see \App\Filament\Resources\RemoteStatuses\Pages\ManageRemoteStatuses::__invoke
* @see app/Filament/Resources/RemoteStatuses/Pages/ManageRemoteStatuses.php:7
* @route '/recruiter/remote-statuses'
*/
ManageRemoteStatuses.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ManageRemoteStatuses.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\RemoteStatuses\Pages\ManageRemoteStatuses::__invoke
* @see app/Filament/Resources/RemoteStatuses/Pages/ManageRemoteStatuses.php:7
* @route '/recruiter/remote-statuses'
*/
ManageRemoteStatuses.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: ManageRemoteStatuses.url(options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\RemoteStatuses\Pages\ManageRemoteStatuses::__invoke
* @see app/Filament/Resources/RemoteStatuses/Pages/ManageRemoteStatuses.php:7
* @route '/recruiter/remote-statuses'
*/
const ManageRemoteStatusesForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageRemoteStatuses.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\RemoteStatuses\Pages\ManageRemoteStatuses::__invoke
* @see app/Filament/Resources/RemoteStatuses/Pages/ManageRemoteStatuses.php:7
* @route '/recruiter/remote-statuses'
*/
ManageRemoteStatusesForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageRemoteStatuses.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\RemoteStatuses\Pages\ManageRemoteStatuses::__invoke
* @see app/Filament/Resources/RemoteStatuses/Pages/ManageRemoteStatuses.php:7
* @route '/recruiter/remote-statuses'
*/
ManageRemoteStatusesForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageRemoteStatuses.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

ManageRemoteStatuses.form = ManageRemoteStatusesForm

export default ManageRemoteStatuses