import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../../wayfinder'
/**
* @see \App\Filament\Resources\Schedules\Pages\ManageSchedules::__invoke
* @see app/Filament/Resources/Schedules/Pages/ManageSchedules.php:7
* @route '/recruiter/schedules'
*/
const ManageSchedules = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ManageSchedules.url(options),
    method: 'get',
})

ManageSchedules.definition = {
    methods: ["get","head"],
    url: '/recruiter/schedules',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\Schedules\Pages\ManageSchedules::__invoke
* @see app/Filament/Resources/Schedules/Pages/ManageSchedules.php:7
* @route '/recruiter/schedules'
*/
ManageSchedules.url = (options?: RouteQueryOptions) => {
    return ManageSchedules.definition.url + queryParams(options)
}

/**
* @see \App\Filament\Resources\Schedules\Pages\ManageSchedules::__invoke
* @see app/Filament/Resources/Schedules/Pages/ManageSchedules.php:7
* @route '/recruiter/schedules'
*/
ManageSchedules.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: ManageSchedules.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Schedules\Pages\ManageSchedules::__invoke
* @see app/Filament/Resources/Schedules/Pages/ManageSchedules.php:7
* @route '/recruiter/schedules'
*/
ManageSchedules.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: ManageSchedules.url(options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\Schedules\Pages\ManageSchedules::__invoke
* @see app/Filament/Resources/Schedules/Pages/ManageSchedules.php:7
* @route '/recruiter/schedules'
*/
const ManageSchedulesForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageSchedules.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Schedules\Pages\ManageSchedules::__invoke
* @see app/Filament/Resources/Schedules/Pages/ManageSchedules.php:7
* @route '/recruiter/schedules'
*/
ManageSchedulesForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageSchedules.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Schedules\Pages\ManageSchedules::__invoke
* @see app/Filament/Resources/Schedules/Pages/ManageSchedules.php:7
* @route '/recruiter/schedules'
*/
ManageSchedulesForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: ManageSchedules.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

ManageSchedules.form = ManageSchedulesForm

export default ManageSchedules