import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\ForgotPasswordController::showLinkRequestForm
* @see app/Http/Controllers/ForgotPasswordController.php:11
* @route '/forgot-password'
*/
export const showLinkRequestForm = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: showLinkRequestForm.url(options),
    method: 'get',
})

showLinkRequestForm.definition = {
    methods: ["get","head"],
    url: '/forgot-password',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\ForgotPasswordController::showLinkRequestForm
* @see app/Http/Controllers/ForgotPasswordController.php:11
* @route '/forgot-password'
*/
showLinkRequestForm.url = (options?: RouteQueryOptions) => {
    return showLinkRequestForm.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\ForgotPasswordController::showLinkRequestForm
* @see app/Http/Controllers/ForgotPasswordController.php:11
* @route '/forgot-password'
*/
showLinkRequestForm.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: showLinkRequestForm.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ForgotPasswordController::showLinkRequestForm
* @see app/Http/Controllers/ForgotPasswordController.php:11
* @route '/forgot-password'
*/
showLinkRequestForm.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: showLinkRequestForm.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\ForgotPasswordController::showLinkRequestForm
* @see app/Http/Controllers/ForgotPasswordController.php:11
* @route '/forgot-password'
*/
const showLinkRequestFormForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: showLinkRequestForm.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ForgotPasswordController::showLinkRequestForm
* @see app/Http/Controllers/ForgotPasswordController.php:11
* @route '/forgot-password'
*/
showLinkRequestFormForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: showLinkRequestForm.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\ForgotPasswordController::showLinkRequestForm
* @see app/Http/Controllers/ForgotPasswordController.php:11
* @route '/forgot-password'
*/
showLinkRequestFormForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: showLinkRequestForm.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

showLinkRequestForm.form = showLinkRequestFormForm

/**
* @see \App\Http\Controllers\ForgotPasswordController::sendResetLinkEmail
* @see app/Http/Controllers/ForgotPasswordController.php:16
* @route '/forgot-password'
*/
export const sendResetLinkEmail = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: sendResetLinkEmail.url(options),
    method: 'post',
})

sendResetLinkEmail.definition = {
    methods: ["post"],
    url: '/forgot-password',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\ForgotPasswordController::sendResetLinkEmail
* @see app/Http/Controllers/ForgotPasswordController.php:16
* @route '/forgot-password'
*/
sendResetLinkEmail.url = (options?: RouteQueryOptions) => {
    return sendResetLinkEmail.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\ForgotPasswordController::sendResetLinkEmail
* @see app/Http/Controllers/ForgotPasswordController.php:16
* @route '/forgot-password'
*/
sendResetLinkEmail.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: sendResetLinkEmail.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ForgotPasswordController::sendResetLinkEmail
* @see app/Http/Controllers/ForgotPasswordController.php:16
* @route '/forgot-password'
*/
const sendResetLinkEmailForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: sendResetLinkEmail.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ForgotPasswordController::sendResetLinkEmail
* @see app/Http/Controllers/ForgotPasswordController.php:16
* @route '/forgot-password'
*/
sendResetLinkEmailForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: sendResetLinkEmail.url(options),
    method: 'post',
})

sendResetLinkEmail.form = sendResetLinkEmailForm

const ForgotPasswordController = { showLinkRequestForm, sendResetLinkEmail }

export default ForgotPasswordController