import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../../wayfinder'
/**
* @see \Filament\Actions\Imports\Http\Controllers\DownloadImportFailureCsv::__invoke
* @see vendor/filament/actions/src/Imports/Http/Controllers/DownloadImportFailureCsv.php:17
* @route '/filament/imports/{import}/failed-rows/download'
*/
const DownloadImportFailureCsv = (args: { import: string | number | { id: string | number } } | [importParam: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: DownloadImportFailureCsv.url(args, options),
    method: 'get',
})

DownloadImportFailureCsv.definition = {
    methods: ["get","head"],
    url: '/filament/imports/{import}/failed-rows/download',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \Filament\Actions\Imports\Http\Controllers\DownloadImportFailureCsv::__invoke
* @see vendor/filament/actions/src/Imports/Http/Controllers/DownloadImportFailureCsv.php:17
* @route '/filament/imports/{import}/failed-rows/download'
*/
DownloadImportFailureCsv.url = (args: { import: string | number | { id: string | number } } | [importParam: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { import: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { import: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            import: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        import: typeof args.import === 'object'
        ? args.import.id
        : args.import,
    }

    return DownloadImportFailureCsv.definition.url
            .replace('{import}', parsedArgs.import.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \Filament\Actions\Imports\Http\Controllers\DownloadImportFailureCsv::__invoke
* @see vendor/filament/actions/src/Imports/Http/Controllers/DownloadImportFailureCsv.php:17
* @route '/filament/imports/{import}/failed-rows/download'
*/
DownloadImportFailureCsv.get = (args: { import: string | number | { id: string | number } } | [importParam: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: DownloadImportFailureCsv.url(args, options),
    method: 'get',
})

/**
* @see \Filament\Actions\Imports\Http\Controllers\DownloadImportFailureCsv::__invoke
* @see vendor/filament/actions/src/Imports/Http/Controllers/DownloadImportFailureCsv.php:17
* @route '/filament/imports/{import}/failed-rows/download'
*/
DownloadImportFailureCsv.head = (args: { import: string | number | { id: string | number } } | [importParam: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: DownloadImportFailureCsv.url(args, options),
    method: 'head',
})

/**
* @see \Filament\Actions\Imports\Http\Controllers\DownloadImportFailureCsv::__invoke
* @see vendor/filament/actions/src/Imports/Http/Controllers/DownloadImportFailureCsv.php:17
* @route '/filament/imports/{import}/failed-rows/download'
*/
const DownloadImportFailureCsvForm = (args: { import: string | number | { id: string | number } } | [importParam: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: DownloadImportFailureCsv.url(args, options),
    method: 'get',
})

/**
* @see \Filament\Actions\Imports\Http\Controllers\DownloadImportFailureCsv::__invoke
* @see vendor/filament/actions/src/Imports/Http/Controllers/DownloadImportFailureCsv.php:17
* @route '/filament/imports/{import}/failed-rows/download'
*/
DownloadImportFailureCsvForm.get = (args: { import: string | number | { id: string | number } } | [importParam: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: DownloadImportFailureCsv.url(args, options),
    method: 'get',
})

/**
* @see \Filament\Actions\Imports\Http\Controllers\DownloadImportFailureCsv::__invoke
* @see vendor/filament/actions/src/Imports/Http/Controllers/DownloadImportFailureCsv.php:17
* @route '/filament/imports/{import}/failed-rows/download'
*/
DownloadImportFailureCsvForm.head = (args: { import: string | number | { id: string | number } } | [importParam: string | number | { id: string | number } ] | string | number | { id: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: DownloadImportFailureCsv.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

DownloadImportFailureCsv.form = DownloadImportFailureCsvForm

export default DownloadImportFailureCsv