import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../wayfinder'
import passwordReset from './password-reset'
/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerLogin::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerLogin.php:7
* @route '/recruiter/login'
*/
export const login = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: login.url(options),
    method: 'get',
})

login.definition = {
    methods: ["get","head"],
    url: '/recruiter/login',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerLogin::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerLogin.php:7
* @route '/recruiter/login'
*/
login.url = (options?: RouteQueryOptions) => {
    return login.definition.url + queryParams(options)
}

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerLogin::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerLogin.php:7
* @route '/recruiter/login'
*/
login.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: login.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerLogin::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerLogin.php:7
* @route '/recruiter/login'
*/
login.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: login.url(options),
    method: 'head',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerLogin::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerLogin.php:7
* @route '/recruiter/login'
*/
const loginForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: login.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerLogin::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerLogin.php:7
* @route '/recruiter/login'
*/
loginForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: login.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerLogin::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerLogin.php:7
* @route '/recruiter/login'
*/
loginForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: login.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

login.form = loginForm

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerRegister::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerRegister.php:7
* @route '/recruiter/register'
*/
export const register = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: register.url(options),
    method: 'get',
})

register.definition = {
    methods: ["get","head"],
    url: '/recruiter/register',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerRegister::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerRegister.php:7
* @route '/recruiter/register'
*/
register.url = (options?: RouteQueryOptions) => {
    return register.definition.url + queryParams(options)
}

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerRegister::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerRegister.php:7
* @route '/recruiter/register'
*/
register.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: register.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerRegister::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerRegister.php:7
* @route '/recruiter/register'
*/
register.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: register.url(options),
    method: 'head',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerRegister::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerRegister.php:7
* @route '/recruiter/register'
*/
const registerForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: register.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerRegister::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerRegister.php:7
* @route '/recruiter/register'
*/
registerForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: register.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\AuthUiEnhancerRegister::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/AuthUiEnhancerRegister.php:7
* @route '/recruiter/register'
*/
registerForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: register.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

register.form = registerForm

/**
* @see \Filament\Auth\Http\Controllers\LogoutController::__invoke
* @see vendor/filament/filament/src/Auth/Http/Controllers/LogoutController.php:10
* @route '/recruiter/logout'
*/
export const logout = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: logout.url(options),
    method: 'post',
})

logout.definition = {
    methods: ["post"],
    url: '/recruiter/logout',
} satisfies RouteDefinition<["post"]>

/**
* @see \Filament\Auth\Http\Controllers\LogoutController::__invoke
* @see vendor/filament/filament/src/Auth/Http/Controllers/LogoutController.php:10
* @route '/recruiter/logout'
*/
logout.url = (options?: RouteQueryOptions) => {
    return logout.definition.url + queryParams(options)
}

/**
* @see \Filament\Auth\Http\Controllers\LogoutController::__invoke
* @see vendor/filament/filament/src/Auth/Http/Controllers/LogoutController.php:10
* @route '/recruiter/logout'
*/
logout.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: logout.url(options),
    method: 'post',
})

/**
* @see \Filament\Auth\Http\Controllers\LogoutController::__invoke
* @see vendor/filament/filament/src/Auth/Http/Controllers/LogoutController.php:10
* @route '/recruiter/logout'
*/
const logoutForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: logout.url(options),
    method: 'post',
})

/**
* @see \Filament\Auth\Http\Controllers\LogoutController::__invoke
* @see vendor/filament/filament/src/Auth/Http/Controllers/LogoutController.php:10
* @route '/recruiter/logout'
*/
logoutForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: logout.url(options),
    method: 'post',
})

logout.form = logoutForm

const auth = {
    login: Object.assign(login, login),
    passwordReset: Object.assign(passwordReset, passwordReset),
    register: Object.assign(register, register),
    logout: Object.assign(logout, logout),
}

export default auth