import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerRequestPasswordReset::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerRequestPasswordReset.php:7
* @route '/recruiter/password-reset/request'
*/
export const request = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: request.url(options),
    method: 'get',
})

request.definition = {
    methods: ["get","head"],
    url: '/recruiter/password-reset/request',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerRequestPasswordReset::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerRequestPasswordReset.php:7
* @route '/recruiter/password-reset/request'
*/
request.url = (options?: RouteQueryOptions) => {
    return request.definition.url + queryParams(options)
}

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerRequestPasswordReset::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerRequestPasswordReset.php:7
* @route '/recruiter/password-reset/request'
*/
request.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: request.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerRequestPasswordReset::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerRequestPasswordReset.php:7
* @route '/recruiter/password-reset/request'
*/
request.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: request.url(options),
    method: 'head',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerRequestPasswordReset::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerRequestPasswordReset.php:7
* @route '/recruiter/password-reset/request'
*/
const requestForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: request.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerRequestPasswordReset::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerRequestPasswordReset.php:7
* @route '/recruiter/password-reset/request'
*/
requestForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: request.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerRequestPasswordReset::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerRequestPasswordReset.php:7
* @route '/recruiter/password-reset/request'
*/
requestForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: request.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

request.form = requestForm

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerResetPassword::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerResetPassword.php:7
* @route '/recruiter/password-reset/reset'
*/
export const reset = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: reset.url(options),
    method: 'get',
})

reset.definition = {
    methods: ["get","head"],
    url: '/recruiter/password-reset/reset',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerResetPassword::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerResetPassword.php:7
* @route '/recruiter/password-reset/reset'
*/
reset.url = (options?: RouteQueryOptions) => {
    return reset.definition.url + queryParams(options)
}

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerResetPassword::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerResetPassword.php:7
* @route '/recruiter/password-reset/reset'
*/
reset.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: reset.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerResetPassword::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerResetPassword.php:7
* @route '/recruiter/password-reset/reset'
*/
reset.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: reset.url(options),
    method: 'head',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerResetPassword::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerResetPassword.php:7
* @route '/recruiter/password-reset/reset'
*/
const resetForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: reset.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerResetPassword::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerResetPassword.php:7
* @route '/recruiter/password-reset/reset'
*/
resetForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: reset.url(options),
    method: 'get',
})

/**
* @see \DiogoGPinto\AuthUIEnhancer\Pages\Auth\PasswordReset\AuthUiEnhancerResetPassword::__invoke
* @see vendor/diogogpinto/filament-auth-ui-enhancer/src/Pages/Auth/PasswordReset/AuthUiEnhancerResetPassword.php:7
* @route '/recruiter/password-reset/reset'
*/
resetForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: reset.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

reset.form = resetForm

const passwordReset = {
    request: Object.assign(request, request),
    reset: Object.assign(reset, reset),
}

export default passwordReset