import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Filament\Resources\Experiences\Pages\ManageExperiences::__invoke
* @see app/Filament/Resources/Experiences/Pages/ManageExperiences.php:7
* @route '/recruiter/experiences'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/recruiter/experiences',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\Experiences\Pages\ManageExperiences::__invoke
* @see app/Filament/Resources/Experiences/Pages/ManageExperiences.php:7
* @route '/recruiter/experiences'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Filament\Resources\Experiences\Pages\ManageExperiences::__invoke
* @see app/Filament/Resources/Experiences/Pages/ManageExperiences.php:7
* @route '/recruiter/experiences'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Experiences\Pages\ManageExperiences::__invoke
* @see app/Filament/Resources/Experiences/Pages/ManageExperiences.php:7
* @route '/recruiter/experiences'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\Experiences\Pages\ManageExperiences::__invoke
* @see app/Filament/Resources/Experiences/Pages/ManageExperiences.php:7
* @route '/recruiter/experiences'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Experiences\Pages\ManageExperiences::__invoke
* @see app/Filament/Resources/Experiences/Pages/ManageExperiences.php:7
* @route '/recruiter/experiences'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\Experiences\Pages\ManageExperiences::__invoke
* @see app/Filament/Resources/Experiences/Pages/ManageExperiences.php:7
* @route '/recruiter/experiences'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

const experiences = {
    index: Object.assign(index, index),
}

export default experiences