import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../../wayfinder'
/**
* @see \App\Filament\Resources\LicensedIns\Pages\ManageLicensedIns::__invoke
* @see app/Filament/Resources/LicensedIns/Pages/ManageLicensedIns.php:7
* @route '/recruiter/licensed-ins'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/recruiter/licensed-ins',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Filament\Resources\LicensedIns\Pages\ManageLicensedIns::__invoke
* @see app/Filament/Resources/LicensedIns/Pages/ManageLicensedIns.php:7
* @route '/recruiter/licensed-ins'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Filament\Resources\LicensedIns\Pages\ManageLicensedIns::__invoke
* @see app/Filament/Resources/LicensedIns/Pages/ManageLicensedIns.php:7
* @route '/recruiter/licensed-ins'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\LicensedIns\Pages\ManageLicensedIns::__invoke
* @see app/Filament/Resources/LicensedIns/Pages/ManageLicensedIns.php:7
* @route '/recruiter/licensed-ins'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Filament\Resources\LicensedIns\Pages\ManageLicensedIns::__invoke
* @see app/Filament/Resources/LicensedIns/Pages/ManageLicensedIns.php:7
* @route '/recruiter/licensed-ins'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\LicensedIns\Pages\ManageLicensedIns::__invoke
* @see app/Filament/Resources/LicensedIns/Pages/ManageLicensedIns.php:7
* @route '/recruiter/licensed-ins'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Filament\Resources\LicensedIns\Pages\ManageLicensedIns::__invoke
* @see app/Filament/Resources/LicensedIns/Pages/ManageLicensedIns.php:7
* @route '/recruiter/licensed-ins'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

const licensedIns = {
    index: Object.assign(index, index),
}

export default licensedIns