import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../wayfinder'
/**
* @see \App\Http\Controllers\JobApplicationController::apply
* @see app/Http/Controllers/JobApplicationController.php:11
* @route '/jobs/{job}/apply'
*/
export const apply = (args: { job: number | { id: number } } | [job: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: apply.url(args, options),
    method: 'post',
})

apply.definition = {
    methods: ["post"],
    url: '/jobs/{job}/apply',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\JobApplicationController::apply
* @see app/Http/Controllers/JobApplicationController.php:11
* @route '/jobs/{job}/apply'
*/
apply.url = (args: { job: number | { id: number } } | [job: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { job: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { job: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            job: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        job: typeof args.job === 'object'
        ? args.job.id
        : args.job,
    }

    return apply.definition.url
            .replace('{job}', parsedArgs.job.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\JobApplicationController::apply
* @see app/Http/Controllers/JobApplicationController.php:11
* @route '/jobs/{job}/apply'
*/
apply.post = (args: { job: number | { id: number } } | [job: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: apply.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\JobApplicationController::apply
* @see app/Http/Controllers/JobApplicationController.php:11
* @route '/jobs/{job}/apply'
*/
const applyForm = (args: { job: number | { id: number } } | [job: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: apply.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\JobApplicationController::apply
* @see app/Http/Controllers/JobApplicationController.php:11
* @route '/jobs/{job}/apply'
*/
applyForm.post = (args: { job: number | { id: number } } | [job: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: apply.url(args, options),
    method: 'post',
})

apply.form = applyForm

/**
* @see \App\Http\Controllers\JobApplicationController::appliedStatus
* @see app/Http/Controllers/JobApplicationController.php:30
* @route '/jobs/{job}/applied-status'
*/
export const appliedStatus = (args: { job: number | { id: number } } | [job: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: appliedStatus.url(args, options),
    method: 'get',
})

appliedStatus.definition = {
    methods: ["get","head"],
    url: '/jobs/{job}/applied-status',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\JobApplicationController::appliedStatus
* @see app/Http/Controllers/JobApplicationController.php:30
* @route '/jobs/{job}/applied-status'
*/
appliedStatus.url = (args: { job: number | { id: number } } | [job: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { job: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { job: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            job: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        job: typeof args.job === 'object'
        ? args.job.id
        : args.job,
    }

    return appliedStatus.definition.url
            .replace('{job}', parsedArgs.job.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\JobApplicationController::appliedStatus
* @see app/Http/Controllers/JobApplicationController.php:30
* @route '/jobs/{job}/applied-status'
*/
appliedStatus.get = (args: { job: number | { id: number } } | [job: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: appliedStatus.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobApplicationController::appliedStatus
* @see app/Http/Controllers/JobApplicationController.php:30
* @route '/jobs/{job}/applied-status'
*/
appliedStatus.head = (args: { job: number | { id: number } } | [job: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: appliedStatus.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\JobApplicationController::appliedStatus
* @see app/Http/Controllers/JobApplicationController.php:30
* @route '/jobs/{job}/applied-status'
*/
const appliedStatusForm = (args: { job: number | { id: number } } | [job: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: appliedStatus.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobApplicationController::appliedStatus
* @see app/Http/Controllers/JobApplicationController.php:30
* @route '/jobs/{job}/applied-status'
*/
appliedStatusForm.get = (args: { job: number | { id: number } } | [job: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: appliedStatus.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\JobApplicationController::appliedStatus
* @see app/Http/Controllers/JobApplicationController.php:30
* @route '/jobs/{job}/applied-status'
*/
appliedStatusForm.head = (args: { job: number | { id: number } } | [job: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: appliedStatus.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

appliedStatus.form = appliedStatusForm

const jobs = {
    apply: Object.assign(apply, apply),
    appliedStatus: Object.assign(appliedStatus, appliedStatus),
}

export default jobs