import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../wayfinder'
/**
* @see \App\Http\Controllers\ProfileController::upload
* @see app/Http/Controllers/ProfileController.php:58
* @route '/resume/upload'
*/
export const upload = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: upload.url(options),
    method: 'post',
})

upload.definition = {
    methods: ["post"],
    url: '/resume/upload',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\ProfileController::upload
* @see app/Http/Controllers/ProfileController.php:58
* @route '/resume/upload'
*/
upload.url = (options?: RouteQueryOptions) => {
    return upload.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\ProfileController::upload
* @see app/Http/Controllers/ProfileController.php:58
* @route '/resume/upload'
*/
upload.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: upload.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ProfileController::upload
* @see app/Http/Controllers/ProfileController.php:58
* @route '/resume/upload'
*/
const uploadForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: upload.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\ProfileController::upload
* @see app/Http/Controllers/ProfileController.php:58
* @route '/resume/upload'
*/
uploadForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: upload.url(options),
    method: 'post',
})

upload.form = uploadForm

const resume = {
    upload: Object.assign(upload, upload),
}

export default resume