## Filament
- Filament is used by this application, check how and where to follow existing application conventions.
- Filament is a Server-Driven UI (SDUI) framework for Laravel. It allows developers to define user interfaces in PHP using structured configuration objects. It is built on top of Livewire, Alpine.js, and Tailwind CSS.
- You can use the ___SINGLE_BACKTICK___search-docs___SINGLE_BACKTICK___ tool to get information from the official Filament documentation when needed. This is very useful for Artisan command arguments, specific code examples, testing functionality, relationship management, and ensuring you're following idiomatic practices.
- Utilize static ___SINGLE_BACKTICK___make()___SINGLE_BACKTICK___ methods for consistent component initialization.

### Artisan
- You must use the Filament specific Artisan commands to create new files or components for Filament. You can find these with the ___SINGLE_BACKTICK___list-artisan-commands___SINGLE_BACKTICK___ tool, or with ___SINGLE_BACKTICK___php artisan___SINGLE_BACKTICK___ and the ___SINGLE_BACKTICK___--help___SINGLE_BACKTICK___ option.
- Inspect the required options, always pass ___SINGLE_BACKTICK___--no-interaction___SINGLE_BACKTICK___, and valid arguments for other options when applicable.

### Filament's Core Features
- Actions: Handle doing something within the application, often with a button or link. Actions encapsulate the UI, the interactive modal window, and the logic that should be executed when the modal window is submitted. They can be used anywhere in the UI and are commonly used to perform one-time actions like deleting a record, sending an email, or updating data in the database based on modal form input.
- Forms: Dynamic forms rendered within other features, such as resources, action modals, table filters, and more.
- Infolists: Read-only lists of data.
- Notifications: Flash notifications displayed to users within the application.
- Panels: The top-level container in Filament that can include all other features like pages, resources, forms, tables, notifications, actions, infolists, and widgets.
- Resources: Static classes that are used to build CRUD interfaces for Eloquent models. Typically live in ___SINGLE_BACKTICK___app/Filament/Resources___SINGLE_BACKTICK___.
- Schemas: Represent components that define the structure and behavior of the UI, such as forms, tables, or lists.
- Tables: Interactive tables with filtering, sorting, pagination, and more.
- Widgets: Small component included within dashboards, often used for displaying data in charts, tables, or as a stat.

### Relationships
- Determine if you can use the ___SINGLE_BACKTICK___relationship()___SINGLE_BACKTICK___ method on form components when you need ___SINGLE_BACKTICK___options___SINGLE_BACKTICK___ for a select, checkbox, repeater, or when building a ___SINGLE_BACKTICK___Fieldset___SINGLE_BACKTICK___:

<code-snippet name="Relationship example for Form Select" lang="php">
Forms\Components\Select::make('user_id')
    ->label('Author')
    ->relationship('author')
    ->required(),
</code-snippet>


## Testing
- It's important to test Filament functionality for user satisfaction.
- Ensure that you are authenticated to access the application within the test.
- Filament uses Livewire, so start assertions with ___SINGLE_BACKTICK___livewire()___SINGLE_BACKTICK___ or ___SINGLE_BACKTICK___Livewire::test()___SINGLE_BACKTICK___.

### Example Tests

<code-snippet name="Filament Table Test" lang="php">
    livewire(ListUsers::class)
        ->assertCanSeeTableRecords($users)
        ->searchTable($users->first()->name)
        ->assertCanSeeTableRecords($users->take(1))
        ->assertCanNotSeeTableRecords($users->skip(1))
        ->searchTable($users->last()->email)
        ->assertCanSeeTableRecords($users->take(-1))
        ->assertCanNotSeeTableRecords($users->take($users->count() - 1));
</code-snippet>

<code-snippet name="Filament Create Resource Test" lang="php">
    livewire(CreateUser::class)
        ->fillForm([
            'name' => 'Howdy',
            'email' => 'howdy@example.com',
        ])
        ->call('create')
        ->assertNotified()
        ->assertRedirect();

    assertDatabaseHas(User::class, [
        'name' => 'Howdy',
        'email' => 'howdy@example.com',
    ]);
</code-snippet>

<code-snippet name="Testing Multiple Panels (setup())" lang="php">
    use Filament\Facades\Filament;

    Filament::setCurrentPanel('app');
</code-snippet>

<code-snippet name="Calling an Action in a Test" lang="php">
    livewire(EditInvoice::class, [
        'invoice' => $invoice,
    ])->callAction('send');

    expect($invoice->refresh())->isSent()->toBeTrue();
</code-snippet>


### Important Version 4 Changes
- File visibility is now ___SINGLE_BACKTICK___private___SINGLE_BACKTICK___ by default.
- The ___SINGLE_BACKTICK___deferFilters___SINGLE_BACKTICK___ method from Filament v3 is now the default behavior in Filament v4, so users must click a button before the filters are applied to the table. To disable this behavior, you can use the ___SINGLE_BACKTICK___deferFilters(false)___SINGLE_BACKTICK___ method.
- The ___SINGLE_BACKTICK___Grid___SINGLE_BACKTICK___, ___SINGLE_BACKTICK___Section___SINGLE_BACKTICK___, and ___SINGLE_BACKTICK___Fieldset___SINGLE_BACKTICK___ layout components no longer span all columns by default.
- The ___SINGLE_BACKTICK___all___SINGLE_BACKTICK___ pagination page method is not available for tables by default.
- All action classes extend ___SINGLE_BACKTICK___Filament\Actions\Action___SINGLE_BACKTICK___. No action classes exist in ___SINGLE_BACKTICK___Filament\Tables\Actions___SINGLE_BACKTICK___.
- The ___SINGLE_BACKTICK___Form___SINGLE_BACKTICK___ & ___SINGLE_BACKTICK___Infolist___SINGLE_BACKTICK___ layout components have been moved to ___SINGLE_BACKTICK___Filament\Schemas\Components___SINGLE_BACKTICK___, for example ___SINGLE_BACKTICK___Grid___SINGLE_BACKTICK___, ___SINGLE_BACKTICK___Section___SINGLE_BACKTICK___, ___SINGLE_BACKTICK___Fieldset___SINGLE_BACKTICK___, ___SINGLE_BACKTICK___Tabs___SINGLE_BACKTICK___, ___SINGLE_BACKTICK___Wizard___SINGLE_BACKTICK___, etc.
- A new ___SINGLE_BACKTICK___Repeater___SINGLE_BACKTICK___ component for Forms has been added.
- Icons now use the ___SINGLE_BACKTICK___Filament\Support\Icons\Heroicon___SINGLE_BACKTICK___ Enum by default. Other options are available and documented.

### Organize Component Classes Structure
- Schema components: ___SINGLE_BACKTICK___Schemas/Components/___SINGLE_BACKTICK___
- Table columns: ___SINGLE_BACKTICK___Tables/Columns/___SINGLE_BACKTICK___
- Table filters: ___SINGLE_BACKTICK___Tables/Filters/___SINGLE_BACKTICK___
- Actions: ___SINGLE_BACKTICK___Actions/___SINGLE_BACKTICK___
<?php /**PATH /home/shahadat/all_projects/job-and-blog/storage/framework/views/8a58cb453ca9b7a60cadcb3b0165f1b6.blade.php ENDPATH**/ ?>